import subprocess
import sys
import emoji
import pandas as pd
from itertools import combinations

# List of required packages
REQUIRED_PACKAGES = ["emoji", "pandas","nltk"]

def install_packages():
    """Install missing required packages."""
    for package in REQUIRED_PACKAGES:
        try:
            __import__(package)
        except ImportError:
            print(f"Package '{package}' is missing. Attempting to install...")
            try:
                subprocess.check_call([sys.executable, "-m", "pip", "install", package])
            except Exception as e:
                print(f"Failed to install package '{package}': {e}")

# Ensure required packages are installed
install_packages()

def remove_last_token_if_emoji(text):
    words = text.split()
    if len(words) > 1 and emoji.is_emoji(words[-1]):
        return " ".join(words[:-1])
    return text

def extract_emojis(text):
    text = str(text)
    return ' '.join([char for char in text if emoji.is_emoji(char)])


    list_token = text.split()
    list_non_x_token = [token for token in list_token if token.lower() != 'x']
    emoji_token = list_non_x_token[-1] if emoji.is_emoji(list_non_x_token[-1]) else None
    non_emoji_tokens = list_non_x_token[:-1] if emoji_token else list_non_x_token
    
    list_pair = []
    for i, j in combinations(non_emoji_tokens, 2):
        if not emoji.is_emoji(i) and not emoji.is_emoji(j):
            sorted_pair = ".".join(sorted([i, j]))
            list_pair.append((sorted_pair, emoji_token))
        else:
            list_pair.append((i, j))
    for token in non_emoji_tokens:
        list_pair.append((token, emoji_token))
    
    return list_pair
def generate_emotion_pair(text, UNK='x', skip_negation_word=True, set_negation_word=None, include_biterm=False, return_set=True):
    # Ensure set_negation_word is initialized as an empty set if not provided
    if set_negation_word is None:
        set_negation_word = set()

    # Split the text into tokens
    list_token = text.split()
    
    # Get the last token (emotion) and remove it from the list
    emj = list_token[-1] if list_token else None
    if emj is not None:
        list_token = list_token[:-1]  # Remove the last token

    list_emotion_tuple = []

    list_modified_token = []
    if skip_negation_word:
        list_modified_token = [token for token in list_token if token not in set_negation_word]  
    else:
        skip_next = False
        for i in range(len(list_token)):
            if skip_next:
                skip_next = False
                continue
            if list_token[i] in set_negation_word:
                if i < len(list_token) - 1 and list_token[i + 1] != UNK:
                    list_modified_token.append(f"{list_token[i]}_{list_token[i + 1]}")
                    skip_next = True
                else:
                    continue
            else:
                list_modified_token.append(list_token[i])

    # Generate emotion pairs
    for token in list_modified_token:
        if token == UNK:
            continue  # Skip UNK tokens

        # Create the emotion pair
        list_emotion_tuple.append((token, emj))

    # If include_biterm is True, create biterms
    if include_biterm:
        for i in range(len(list_modified_token)):
            for j in range(i + 1, len(list_modified_token)):
                if list_modified_token[i] != UNK and list_modified_token[j] != UNK:
                    sorted_biterm = ".".join(sorted([list_modified_token[i], list_modified_token[j]]))
                    list_emotion_tuple.append((sorted_biterm, emj))

    # Return unique tuples if return_set is True
    if return_set:
        return set(list_emotion_tuple)

    return list_emotion_tuple

# # Example usage:
# text1 = "x no x x x not bummer x x x x x x x day x x x 😉"
# # negation_words = {'not'}

# result1 = generate_emotion_pair(text1, skip_negation_word=True, set_negation_word=set_NegationWord, include_biterm=False)
# print(result1)

# result2 = generate_emotion_pair(text1, skip_negation_word=False, set_negation_word=set_NegationWord, include_biterm=False)
# print(result2)

# result3 = generate_emotion_pair(text1, skip_negation_word=False, set_negation_word=set_NegationWord, include_biterm=True)
# print(result3)


import emoji
import nltk
from nltk.corpus import wordnet
nltk.download('wordnet')
from nltk.stem import WordNetLemmatizer
# nltk.download('omw-1.4') #multilingual


def extract_emoword_context_from_text(
        text,
        remove_trailing_emoji=True,        
        return_lemmatized=True, 
        dict_emo_label=dict(), 
        set_stopword=set(), 
        return_negation=False, set_negation_word=set(), NEGATE_MARKER='⊖', 
        return_combination=False, COMBINE_MARKER='⊕'
        ):

    def filter_trailing_emoji(text):
        tokens = text.split()
        while tokens and emoji.is_emoji(tokens[-1]):
            tokens = tokens[:-1]
        return " ".join(tokens)
    
    if (remove_trailing_emoji==True):
        text = filter_trailing_emoji(text)    

    def lemmatize_text(list_token):
        lemmatizer = WordNetLemmatizer()
        list_lemmatized_token = []

        for token in list_token:
            lemma = lemmatizer.lemmatize(token.lower())
            # Check if the lemma exists in WordNet by looking for synsets
            if wordnet.synsets(lemma):
                list_lemmatized_token.append(lemma)

        return ' '.join(list_lemmatized_token)

    if (return_lemmatized==True):
        text=lemmatize_text(text.split())

    list_indexed_word = [(index1, word1) for index1, word1 in enumerate(text.split())]
    list_output=[]
    # # You can utilize dict_emo_label here as needed
    for index1, word1 in list_indexed_word:
       token=word1
       test_token=''
       negator=''
       step_back=1
       if (token in dict_emo_label):
        if (return_negation==True):
            if index1-1>0:
                test_token=list_indexed_word[index1-1][1]
                if ( (test_token in set_negation_word) and (emoji.is_emoji(test_token)==False) ) :
                    negator=test_token+NEGATE_MARKER
                    step_back=step_back+1
        list_output.append(negator+token)

        if (return_combination==True):
            prev_token=''
            next_token=''
            if index1-step_back>=0:
                test_token=list_indexed_word[index1-step_back][1]
                if( (test_token not in set_stopword) and (emoji.is_emoji(test_token)==False)):
                    prev_token=test_token+COMBINE_MARKER
            #unigram/bigram/negationbigram
            if not any(item == prev_token+negator+token for item in list_output):
                list_output.append(prev_token+negator+token)

            if index1+1<len(list_indexed_word):
                test_token=list_indexed_word[index1+1][1]
                if( (test_token not in set_stopword) and (emoji.is_emoji(test_token)==False) ):
                    next_token=COMBINE_MARKER+test_token

            #unigram/bigram/negationbigram
            if not any(item == negator+token+next_token for item in list_output):
                list_output.append(negator+token+next_token)

            #unigram/bigram/negationbigram/trigram
            if not any(item == prev_token+negator+token+next_token for item in list_output):
                list_output.append(prev_token+negator+token+next_token)

    return ' '.join(list_output)