from datetime import datetime

class Timer:
    def __enter__(self):
        self.start_time = datetime.now()
        print(f"Timer started at {self.start_time.strftime('%Y-%m-%d %H:%M:%S.%f')}")
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        stop_time = datetime.now()
        duration = stop_time - self.start_time
        print(f"Timer stopped at {stop_time.strftime('%Y-%m-%d %H:%M:%S.%f')}")
        print(f"Elapsed Time: {duration}")
