

def detect_negation_in_text(text, set_stop_word=set(), set_negation_word=set(), NEGATE_MARKER='⊖', return_string=False):
    # Split the input text into tokens (words)
    list_token = text.split(' ')
    list_output = []
    prev_token = ''

    for token in list_token:
        # Skip stop words
        if token not in set_stop_word:
            #print(token)
            if prev_token in set_negation_word:
                # If the previous token is a negation word, modify the last added token
                if list_output:  # Check if list_output is not empty
                    # Replace the last token with the negation marker and the current token
                    list_output[-1] = list_output[-1] + NEGATE_MARKER + token
                else:
                    # Add if the output list is empty
                    list_output.append(prev_token + NEGATE_MARKER + token)
            else:
                list_output.append(token)  # Add the current token if no negation

        # Update prev_token only if the current token is a negation word
        if token in set_negation_word:
            prev_token = token
        else:
            prev_token = ''

    # Return the output as a string or a list based on the return_string flag
    if return_string:
        return ' '.join(list_output)
    else:
        return list_output

def get_negation_aware_emo_label_for_text(text,dict_emo_label, dict_emo_reverse=dict(),NEGATE_MARKER='⊖',COMBINE_MARKER='⊕'):
    if len(dict_emo_reverse)==0:
        dict_emo_reverse = {
            'positive': 'negative', 'negative': 'positive',
            'joy': 'sadness', 'sadness': 'joy',
            'anger': 'fear', 'fear': 'anger',
            'trust': 'disgust', 'disgust': 'trust',
            'anticipation': 'surprise', 'surprise': 'anticipation'
        }
    
    list_output = []
    for token in text.split():
      for subtoken in token.split(COMBINE_MARKER):
        #print(token)
        if NEGATE_MARKER in token:
            token1 = token.split(NEGATE_MARKER)[1]
            list_found = dict_emo_label.get(token1, [])
            list_output.append([dict_emo_reverse.get(item, '') for item in list_found])
        else:
            list_found = dict_emo_label.get(token, [])
            list_output.append(list_found)
    
    return list_output